-- Do good and not evil
-- Author: Manfred Blech, DM4BL seit 16. Januar 2024

fname = "calls.txt"

fh = io.open(fname,"r")
if fh then
  content = fh:read("*a")
  fh:close()
  fileSize = #content
  print( "file size = ".. fileSize )
else
  error( "could not open file "..fname )
end

counter = 0
Chapter, Title = "1", "Liste der personengebundenen Rufzeichen gemäß § 3 Abs. 1 und Abs. 3 Nr. 1 des Amateurfunkgesetzes"

function printChapter( number, title )
  print( ("Kapitel %s : %s"):format( number, title ) )
end

function blockExtract( start, pos, section )
  counter = counter + 1
  block = content:sub(start,pos-1):gsub(string.char(2),"-"):gsub("[\r\n]+"," ")
  Seite, SeitenRest = block:match("Seite (%d+)%s+(%S.+)")
  block = block:gsub("(.-) Seite %d+(.*)","%1%2"):gsub("%s+"," ")

  if SeitenRest then
  --print( Seite, SeitenRest )
    if SeitenRest:match("Seite %d+") then
      block = block:sub(1,-#SeitenRest-1)

      Chapter, Title = SeitenRest:match("^(%d+)%s+(.-)%sSeite")
    end
  end

  Rufzeichen, Klasse, Info = block:match("^(.-),%s+(%w),%s+(.+)")

--print( pos, counter, block )

  Name, Rest = Info:match("^(%w[^;,]+)[;,] (.*)")
  if Rest then
  --print( ("%5d |%2s| %-10s | %s | %-45s | %s"):format( counter, section, Rufzeichen, Klasse, Name, Rest ) )
    local rowCount = 0
    for Addr in Rest:gmatch("([^,]+),?") do
      rowCount = rowCount + 1
      if rowCount == 1 then
        print( ("%5d |%2s| %-10s | %s | %-45s | %s"):format( counter, section, Rufzeichen, Klasse, Name, Addr ) )
      else
        print( ("%5d |%2s| %-10s | %s | %-45s | %s"):format( counter, section, Rufzeichen, Klasse, "", Addr ) )
      end
    end
  else
    print( ("%5d |%2s| %-10s | %s | %s"):format( counter, section, Rufzeichen, Klasse, Info ) )
  end
end

printChapter( Chapter, Title )

start = nil
for pos, ID in content:gmatch("()(D%w%d%w+),") do
  if start then
    local section = Chapter
    blockExtract( start, pos, Chapter )
    if Chapter ~= section then
      printChapter( Chapter, Title )
    end
  end
--print( string.rep("-",150) )
--print( pos, ID )
  start = pos
end
blockExtract( start, fileSize+1, Chapter )
